<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
include("db.php"); // DB connection

$message = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {

    $first_name    = mysqli_real_escape_string($conn, $_POST['first_name']);
    $middle_name   = mysqli_real_escape_string($conn, $_POST['middle_name'] ?? '');
    $last_name     = mysqli_real_escape_string($conn, $_POST['last_name']);
    $dob           = mysqli_real_escape_string($conn, $_POST['dob']);
    $qualification = mysqli_real_escape_string($conn, $_POST['qualification']);
    $address       = mysqli_real_escape_string($conn, $_POST['address']);
    $mobile        = mysqli_real_escape_string($conn, $_POST['mobile']);
    $email         = mysqli_real_escape_string($conn, $_POST['email']);
    $password      = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $token         = bin2hex(random_bytes(16));

    // Check if email exists
    $check = mysqli_query($conn, "SELECT id FROM users WHERE email='$email'");
    if(mysqli_num_rows($check) > 0){
        $message = "<div class='alert alert-danger'>❌ Email already registered.</div>";
    } else {

        // Resume upload
        $resume_path = "";
        if (!empty($_FILES['resume']['name'])) {
            $target_dir = __DIR__ . "/uploads/resumes/";
            if (!is_dir($target_dir)) mkdir($target_dir, 0777, true);
            $resume_name = time() . "_" . basename($_FILES['resume']['name']);
            $resume_path = "uploads/resumes/" . $resume_name;
            move_uploaded_file($_FILES['resume']['tmp_name'], $target_dir . $resume_name);
        }

        // Insert user
        $query = "INSERT INTO users 
            (first_name, middle_name, last_name, date_of_birth, highest_qualification, resume, address, email, password, mobile_number, activation_token, is_active) 
            VALUES 
            ('$first_name', '$middle_name', '$last_name', '$dob', '$qualification', '$resume_path', '$address', '$email', '$password', '$mobile', '$token', 0)";

        if (mysqli_query($conn, $query)) {
            // Build activation link dynamically based on current domain
            $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
            $domain = $_SERVER['HTTP_HOST']; // e.g., test.quickbizsolutions.in
            $activation_link = $protocol . $domain . "/pharma_research/activate.php?token=$token";

            // Send activation email
            $to = $email;
            $subject = "Activate Your Pharma Research Account";
            $body = "<h2>Welcome, $first_name!</h2>
                     <p>Thank you for registering with <b>Pharma Research</b>.</p>
                     <p>Please click the link below to activate your account:</p>
                     <p><a href='$activation_link'>$activation_link</a></p>";
            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
            $headers .= "From: Pharma Research <no-reply@" . $domain . ">" . "\r\n";

            if(mail($to, $subject, $body, $headers)){
                $message = "<div class='alert alert-success'>✅ Account created! Please check your email ($email) to activate your account.</div>";
            } else {
                $message = "<div class='alert alert-warning'>⚠️ Account created, but email could not be sent.</div>";
            }

        } else {
            $message = "<div class='alert alert-danger'>❌ Error: " . mysqli_error($conn) . "</div>";
        }
    }
}
?>


<!DOCTYPE html>
<html>
<head>
  <title>Signup - Pharma Research</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5">
  <div class="row justify-content-center">
    <div class="col-md-6">
      <div class="card shadow-lg p-4">
        <h3 class="mb-3 text-center">Signup - Pharma Research</h3>

        <!-- Show error/success messages -->
        <?php if (!empty($message)) echo $message; ?>

        <form method="POST" enctype="multipart/form-data">
          <div class="mb-3">
            <label class="form-label">First Name</label>
            <input type="text" name="first_name" class="form-control" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Middle Name (optional)</label>
            <input type="text" name="middle_name" class="form-control">
          </div>
          <div class="mb-3">
            <label class="form-label">Last Name</label>
            <input type="text" name="last_name" class="form-control" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Date of Birth</label>
            <input type="date" name="dob" class="form-control" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Highest Qualification</label>
            <input type="text" name="qualification" class="form-control" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Upload Resume</label>
            <input type="file" name="resume" class="form-control">
          </div>
          <div class="mb-3">
            <label class="form-label">Address</label>
            <textarea name="address" class="form-control" required></textarea>
          </div>
          <div class="mb-3">
            <label class="form-label">Email ID</label>
            <input type="email" name="email" class="form-control" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Password (min 6 characters)</label>
            <input type="password" name="password" class="form-control" required minlength="6">
          </div>
          <div class="mb-3">
            <label class="form-label">Mobile Number</label>
            <input type="text" name="mobile" class="form-control" required>
          </div>
          <button type="submit" class="btn btn-primary w-100">Signup</button>
        </form>

      </div>
    </div>
  </div>
</div>
</body>
</html>
