<?php
session_start();
include "db.php";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST['email'];
    $password = $_POST['password'];

    $res = $conn->query("SELECT * FROM users WHERE email='$email' AND is_active=1");
    if ($res->num_rows > 0) {
        $user = $res->fetch_assoc();
        if (password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            header("Location: dashboard.php");
            exit;
        } else {
            $error = "Invalid password.";
        }
    } else {
        $error = "User not found or not activated.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Login - Pharma Research</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<style>
    body {
        background: linear-gradient(135deg, #74ebd5, #ACB6E5);
        min-height: 100vh;
        display: flex;
        justify-content: center;
        align-items: center;
        font-family: 'Segoe UI', sans-serif;
    }
    .login-card {
        background: #ffffffcc;
        backdrop-filter: blur(10px);
        padding: 2rem;
        border-radius: 1rem;
        box-shadow: 0 0 30px rgba(0,0,0,0.2);
        max-width: 400px;
        width: 100%;
    }
    .login-card h2 {
        font-weight: 700;
    }
    .form-control:focus {
        border-color: #5e72e4;
        box-shadow: 0 0 0 0.2rem rgba(94,114,228,0.25);
    }
    .btn-login {
        background: #5e72e4;
        border: none;
    }
    .btn-login:hover {
        background: #324cdd;
    }
    .input-group-text {
        background: #f0f2f5;
        border: none;
    }
    .password-toggle {
        cursor: pointer;
    }
    @media (max-width: 576px) {
        .login-card {
            padding: 1.5rem;
        }
    }
</style>
</head>
<body>

<div class="login-card text-center">
    <h2 class="mb-4 text-primary"><i class="bi bi-shield-lock-fill"></i> Pharma Research</h2>

    <?php if(isset($error)): ?>
        <div class="alert alert-danger py-2"><?php echo $error; ?></div>
    <?php endif; ?>

    <form method="POST">
        <div class="mb-3 input-group">
            <span class="input-group-text"><i class="bi bi-envelope-fill"></i></span>
            <input type="email" name="email" class="form-control" placeholder="Email Address" required>
        </div>

        <div class="mb-3 input-group">
            <span class="input-group-text"><i class="bi bi-lock-fill"></i></span>
            <input type="password" id="password" name="password" class="form-control" placeholder="Password" required>
            <span class="input-group-text password-toggle" onclick="togglePassword()">
                <i id="toggleIcon" class="bi bi-eye-fill"></i>
            </span>
        </div>

        <button type="submit" class="btn btn-login w-100 py-2">Login</button>
    </form>

    <p class="mt-3">Don’t have an account? <a href="signup.php" class="text-primary fw-semibold">Sign up</a></p>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
function togglePassword() {
    const passwordField = document.getElementById('password');
    const toggleIcon = document.getElementById('toggleIcon');
    if (passwordField.type === 'password') {
        passwordField.type = 'text';
        toggleIcon.classList.replace('bi-eye-fill', 'bi-eye-slash-fill');
    } else {
        passwordField.type = 'password';
        toggleIcon.classList.replace('bi-eye-slash-fill', 'bi-eye-fill');
    }
}
</script>
</body>
</html>
